<?php $__env->startSection('title', 'إعدادات النظام'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3 mb-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">قائمة الإعدادات</h5>
                </div>
                <div class="list-group list-group-flush">
                    <a href="#generalSettings" class="list-group-item list-group-item-action active" data-bs-toggle="list">
                        <i class="bi bi-gear me-2"></i> الإعدادات العامة
                    </a>
                    <a href="#companySettings" class="list-group-item list-group-item-action" data-bs-toggle="list">
                        <i class="bi bi-building me-2"></i> معلومات الشركة
                    </a>
                    <a href="#currencySettings" class="list-group-item list-group-item-action" data-bs-toggle="list">
                        <i class="bi bi-currency-exchange me-2"></i> إعدادات العملات
                    </a>
                    <a href="#remittanceSettings" class="list-group-item list-group-item-action" data-bs-toggle="list">
                        <i class="bi bi-send me-2"></i> إعدادات الحوالات
                    </a>
                    <a href="#userSettings" class="list-group-item list-group-item-action" data-bs-toggle="list">
                        <i class="bi bi-people me-2"></i> إدارة المستخدمين
                    </a>
                    <a href="#backupSettings" class="list-group-item list-group-item-action" data-bs-toggle="list">
                        <i class="bi bi-archive me-2"></i> النسخ الاحتياطي
                    </a>
                    <a href="#systemLogs" class="list-group-item list-group-item-action" data-bs-toggle="list">
                        <i class="bi bi-journal-text me-2"></i> سجلات النظام
                    </a>
                </div>
            </div>
        </div>
        
        <div class="col-md-9">
            <div class="tab-content">
                <!-- الإعدادات العامة -->
                <div class="tab-pane fade show active" id="generalSettings">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">الإعدادات العامة</h5>
                            <button type="button" class="btn btn-primary btn-sm" id="saveGeneralSettings">
                                <i class="bi bi-save"></i> حفظ التغييرات
                            </button>
                        </div>
                        <div class="card-body">
                            <form id="generalSettingsForm">
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="system_name" class="form-label">اسم النظام</label>
                                        <input type="text" class="form-control" id="system_name" name="system_name" value="CodePlus">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="system_version" class="form-label">إصدار النظام</label>
                                        <input type="text" class="form-control" id="system_version" name="system_version" value="1.0.0" readonly>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="default_language" class="form-label">اللغة الافتراضية</label>
                                        <select class="form-select" id="default_language" name="default_language">
                                            <option value="ar" selected>العربية</option>
                                            <option value="en">الإنجليزية</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="default_currency" class="form-label">العملة الافتراضية</label>
                                        <select class="form-select" id="default_currency" name="default_currency">
                                            <option value="1">الدولار الأمريكي (USD)</option>
                                            <option value="2">اليورو (EUR)</option>
                                            <option value="3">الريال السعودي (SAR)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="date_format" class="form-label">صيغة التاريخ</label>
                                        <select class="form-select" id="date_format" name="date_format">
                                            <option value="Y-m-d" selected>YYYY-MM-DD</option>
                                            <option value="d/m/Y">DD/MM/YYYY</option>
                                            <option value="m/d/Y">MM/DD/YYYY</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="time_format" class="form-label">صيغة الوقت</label>
                                        <select class="form-select" id="time_format" name="time_format">
                                            <option value="H:i" selected>24 ساعة</option>
                                            <option value="h:i A">12 ساعة</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="timezone" class="form-label">المنطقة الزمنية</label>
                                        <select class="form-select" id="timezone" name="timezone">
                                            <option value="UTC" selected>UTC</option>
                                            <option value="Asia/Riyadh">آسيا/الرياض</option>
                                            <option value="Asia/Dubai">آسيا/دبي</option>
                                            <option value="Asia/Amman">آسيا/عمان</option>
                                            <option value="Africa/Cairo">أفريقيا/القاهرة</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="decimal_separator" class="form-label">فاصل العلامة العشرية</label>
                                        <select class="form-select" id="decimal_separator" name="decimal_separator">
                                            <option value="." selected>نقطة (.)</option>
                                            <option value=",">فاصلة (,)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="thousand_separator" class="form-label">فاصل الآلاف</label>
                                        <select class="form-select" id="thousand_separator" name="thousand_separator">
                                            <option value="," selected>فاصلة (,)</option>
                                            <option value=".">نقطة (.)</option>
                                            <option value=" ">مسافة ( )</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="decimal_places" class="form-label">عدد الخانات العشرية</label>
                                        <select class="form-select" id="decimal_places" name="decimal_places">
                                            <option value="0">0</option>
                                            <option value="1">1</option>
                                            <option value="2" selected>2</option>
                                            <option value="3">3</option>
                                            <option value="4">4</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_email_notifications" name="enable_email_notifications" checked>
                                            <label class="form-check-label" for="enable_email_notifications">تفعيل إشعارات البريد الإلكتروني</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_sms_notifications" name="enable_sms_notifications">
                                            <label class="form-check-label" for="enable_sms_notifications">تفعيل إشعارات الرسائل القصيرة</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <label for="copyright_text" class="form-label">نص حقوق الملكية</label>
                                        <input type="text" class="form-control" id="copyright_text" name="copyright_text" value="جميع الحقوق محفوظة © <?php echo e(date('Y')); ?> CodePlus - نظام الصرافة والحوالات">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- معلومات الشركة -->
                <div class="tab-pane fade" id="companySettings">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">معلومات الشركة</h5>
                            <button type="button" class="btn btn-primary btn-sm" id="saveCompanySettings">
                                <i class="bi bi-save"></i> حفظ التغييرات
                            </button>
                        </div>
                        <div class="card-body">
                            <form id="companySettingsForm">
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="company_name" class="form-label">اسم الشركة</label>
                                        <input type="text" class="form-control" id="company_name" name="company_name" value="شركة CodePlus للصرافة والحوالات">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="company_email" class="form-label">البريد الإلكتروني</label>
                                        <input type="email" class="form-control" id="company_email" name="company_email" value="info@codeplus.com">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="company_phone" class="form-label">رقم الهاتف</label>
                                        <input type="text" class="form-control" id="company_phone" name="company_phone" value="+966 12 345 6789">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="company_mobile" class="form-label">رقم الجوال</label>
                                        <input type="text" class="form-control" id="company_mobile" name="company_mobile" value="+966 50 123 4567">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="company_address" class="form-label">العنوان</label>
                                        <input type="text" class="form-control" id="company_address" name="company_address" value="شارع الملك فهد، الرياض، المملكة العربية السعودية">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="company_website" class="form-label">الموقع الإلكتروني</label>
                                        <input type="url" class="form-control" id="company_website" name="company_website" value="https://www.codeplus.com">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="tax_number" class="form-label">الرقم الضريبي</label>
                                        <input type="text" class="form-control" id="tax_number" name="tax_number" value="123456789">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="commercial_register" class="form-label">السجل التجاري</label>
                                        <input type="text" class="form-control" id="commercial_register" name="commercial_register" value="987654321">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <label for="company_logo" class="form-label">شعار الشركة</label>
                                        <input type="file" class="form-control" id="company_logo" name="company_logo">
                                        <div class="form-text">الحد الأقصى لحجم الملف: 2 ميجابايت. الصيغ المدعومة: JPG، PNG، SVG.</div>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <label for="company_description" class="form-label">نبذة عن الشركة</label>
                                        <textarea class="form-control" id="company_description" name="company_description" rows="3">شركة CodePlus للصرافة والحوالات هي شركة رائدة في مجال الصرافة وتحويل الأموال، تأسست عام 2025 لتقديم خدمات مالية متكاملة وموثوقة للعملاء.</textarea>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- إعدادات العملات -->
                <div class="tab-pane fade" id="currencySettings">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">إعدادات العملات</h5>
                            <button type="button" class="btn btn-primary btn-sm" id="saveCurrencySettings">
                                <i class="bi bi-save"></i> حفظ التغييرات
                            </button>
                        </div>
                        <div class="card-body">
                            <form id="currencySettingsForm">
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="auto_update_rates" class="form-label">تحديث أسعار الصرف</label>
                                        <select class="form-select" id="auto_update_rates" name="auto_update_rates">
                                            <option value="manual" selected>يدوي</option>
                                            <option value="daily">تلقائي (يومي)</option>
                                            <option value="hourly">تلقائي (كل ساعة)</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="exchange_rate_api" class="form-label">مصدر أسعار الصرف</label>
                                        <select class="form-select" id="exchange_rate_api" name="exchange_rate_api">
                                            <option value="manual" selected>إدخال يدوي</option>
                                            <option value="openexchangerates">Open Exchange Rates</option>
                                            <option value="currencylayer">Currency Layer</option>
                                            <option value="fixer">Fixer.io</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="api_key" class="form-label">مفتاح API</label>
                                        <input type="text" class="form-control" id="api_key" name="api_key" placeholder="أدخل مفتاح API لخدمة أسعار الصرف">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="default_markup" class="form-label">هامش الربح الافتراضي (%)</label>
                                        <input type="number" class="form-control" id="default_markup" name="default_markup" value="2.5" step="0.1" min="0">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_rate_alerts" name="enable_rate_alerts" checked>
                                            <label class="form-check-label" for="enable_rate_alerts">تفعيل تنبيهات تغير الأسعار</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="rate_alert_threshold" class="form-label">حد التنبيه (%)</label>
                                        <input type="number" class="form-control" id="rate_alert_threshold" name="rate_alert_threshold" value="5" step="0.1" min="0">
                                    </div>
                                </div>
                                <hr>
                                <h6 class="mb-3">عمولات الصرف الافتراضية</h6>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="default_buy_commission" class="form-label">عمولة الشراء الافتراضية (%)</label>
                                        <input type="number" class="form-control" id="default_buy_commission" name="default_buy_commission" value="1" step="0.1" min="0">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="default_sell_commission" class="form-label">عمولة البيع الافتراضية (%)</label>
                                        <input type="number" class="form-control" id="default_sell_commission" name="default_sell_commission" value="1.5" step="0.1" min="0">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="min_commission_amount" class="form-label">الحد الأدنى للعمولة</label>
                                        <input type="number" class="form-control" id="min_commission_amount" name="min_commission_amount" value="5" step="0.1" min="0">
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check form-switch mt-4">
                                            <input class="form-check-input" type="checkbox" id="apply_commission_per_transaction" name="apply_commission_per_transaction" checked>
                                            <label class="form-check-label" for="apply_commission_per_transaction">تطبيق العمولة على كل معاملة</label>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- إعدادات الحوالات -->
                <div class="tab-pane fade" id="remittanceSettings">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">إعدادات الحوالات</h5>
                            <button type="button" class="btn btn-primary btn-sm" id="saveRemittanceSettings">
                                <i class="bi bi-save"></i> حفظ التغييرات
                            </button>
                        </div>
                        <div class="card-body">
                            <form id="remittanceSettingsForm">
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="remittance_number_prefix" class="form-label">بادئة رقم الحوالة</label>
                                        <input type="text" class="form-control" id="remittance_number_prefix" name="remittance_number_prefix" value="REM-">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="remittance_number_digits" class="form-label">عدد أرقام الحوالة</label>
                                        <select class="form-select" id="remittance_number_digits" name="remittance_number_digits">
                                            <option value="4">4 أرقام</option>
                                            <option value="6" selected>6 أرقام</option>
                                            <option value="8">8 أرقام</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="default_remittance_commission" class="form-label">عمولة الحوالة الافتراضية (%)</label>
                                        <input type="number" class="form-control" id="default_remittance_commission" name="default_remittance_commission" value="2" step="0.1" min="0">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="min_remittance_commission" class="form-label">الحد الأدنى لعمولة الحوالة</label>
                                        <input type="number" class="form-control" id="min_remittance_commission" name="min_remittance_commission" value="10" step="0.1" min="0">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="max_remittance_amount" class="form-label">الحد الأقصى لمبلغ الحوالة</label>
                                        <input type="number" class="form-control" id="max_remittance_amount" name="max_remittance_amount" value="50000" step="1" min="0">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="remittance_expiry_days" class="form-label">مدة صلاحية الحوالة (بالأيام)</label>
                                        <input type="number" class="form-control" id="remittance_expiry_days" name="remittance_expiry_days" value="30" step="1" min="1">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="require_id_for_remittance" name="require_id_for_remittance" checked>
                                            <label class="form-check-label" for="require_id_for_remittance">طلب هوية للحوالات</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_remittance_tracking" name="enable_remittance_tracking" checked>
                                            <label class="form-check-label" for="enable_remittance_tracking">تفعيل تتبع الحوالات</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="send_remittance_notifications" name="send_remittance_notifications" checked>
                                            <label class="form-check-label" for="send_remittance_notifications">إرسال إشعارات للحوالات</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="enable_remittance_cancellation" name="enable_remittance_cancellation" checked>
                                            <label class="form-check-label" for="enable_remittance_cancellation">السماح بإلغاء الحوالات</label>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <h6 class="mb-3">متطلبات الحوالات حسب المبلغ</h6>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>نطاق المبلغ</th>
                                                <th>المتطلبات</th>
                                                <th>العمولة (%)</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>0 - 1,000</td>
                                                <td>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="req_id_small" checked>
                                                        <label class="form-check-label" for="req_id_small">هوية</label>
                                                    </div>
                                                </td>
                                                <td>
                                                    <input type="number" class="form-control form-control-sm" value="3" step="0.1" min="0">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>1,001 - 5,000</td>
                                                <td>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="req_id_medium" checked>
                                                        <label class="form-check-label" for="req_id_medium">هوية</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="req_address_medium" checked>
                                                        <label class="form-check-label" for="req_address_medium">عنوان</label>
                                                    </div>
                                                </td>
                                                <td>
                                                    <input type="number" class="form-control form-control-sm" value="2.5" step="0.1" min="0">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>5,001 - 50,000</td>
                                                <td>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="req_id_large" checked>
                                                        <label class="form-check-label" for="req_id_large">هوية</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="req_address_large" checked>
                                                        <label class="form-check-label" for="req_address_large">عنوان</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="req_purpose_large" checked>
                                                        <label class="form-check-label" for="req_purpose_large">غرض التحويل</label>
                                                    </div>
                                                </td>
                                                <td>
                                                    <input type="number" class="form-control form-control-sm" value="2" step="0.1" min="0">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- إدارة المستخدمين -->
                <div class="tab-pane fade" id="userSettings">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">إدارة المستخدمين</h5>
                            <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addUserModal">
                                <i class="bi bi-person-plus"></i> إضافة مستخدم
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>اسم المستخدم</th>
                                            <th>البريد الإلكتروني</th>
                                            <th>الدور</th>
                                            <th>الحالة</th>
                                            <th>تاريخ الإنشاء</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>مدير النظام</td>
                                            <td>admin@codeplus.com</td>
                                            <td><span class="badge bg-danger">مدير النظام</span></td>
                                            <td><span class="badge bg-success">نشط</span></td>
                                            <td>2025-04-19</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editUserModal">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#userPermissionsModal">
                                                        <i class="bi bi-shield"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger" disabled>
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>موظف صرافة</td>
                                            <td>cashier@codeplus.com</td>
                                            <td><span class="badge bg-primary">موظف</span></td>
                                            <td><span class="badge bg-success">نشط</span></td>
                                            <td>2025-04-19</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editUserModal">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#userPermissionsModal">
                                                        <i class="bi bi-shield"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>مشرف حوالات</td>
                                            <td>remittance@codeplus.com</td>
                                            <td><span class="badge bg-info">مشرف</span></td>
                                            <td><span class="badge bg-success">نشط</span></td>
                                            <td>2025-04-19</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editUserModal">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#userPermissionsModal">
                                                        <i class="bi bi-shield"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            
                            <hr>
                            
                            <h6 class="mb-3">الأدوار والصلاحيات</h6>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>اسم الدور</th>
                                            <th>الوصف</th>
                                            <th>عدد المستخدمين</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>مدير النظام</td>
                                            <td>صلاحيات كاملة للنظام</td>
                                            <td>1</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editRoleModal">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger" disabled>
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>مشرف</td>
                                            <td>صلاحيات إدارة المعاملات والتقارير</td>
                                            <td>1</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editRoleModal">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>موظف</td>
                                            <td>صلاحيات إجراء المعاملات والحوالات</td>
                                            <td>1</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editRoleModal">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- النسخ الاحتياطي -->
                <div class="tab-pane fade" id="backupSettings">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">النسخ الاحتياطي</h5>
                            <button type="button" class="btn btn-primary btn-sm" id="createBackupBtn">
                                <i class="bi bi-download"></i> إنشاء نسخة احتياطية
                            </button>
                        </div>
                        <div class="card-body">
                            <form id="backupSettingsForm">
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="auto_backup" class="form-label">النسخ الاحتياطي التلقائي</label>
                                        <select class="form-select" id="auto_backup" name="auto_backup">
                                            <option value="disabled">معطل</option>
                                            <option value="daily" selected>يومي</option>
                                            <option value="weekly">أسبوعي</option>
                                            <option value="monthly">شهري</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="backup_time" class="form-label">وقت النسخ الاحتياطي</label>
                                        <input type="time" class="form-control" id="backup_time" name="backup_time" value="02:00">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="backup_retention" class="form-label">مدة الاحتفاظ بالنسخ الاحتياطية</label>
                                        <select class="form-select" id="backup_retention" name="backup_retention">
                                            <option value="7">7 أيام</option>
                                            <option value="14">14 يوم</option>
                                            <option value="30" selected>30 يوم</option>
                                            <option value="60">60 يوم</option>
                                            <option value="90">90 يوم</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="backup_location" class="form-label">موقع النسخ الاحتياطي</label>
                                        <select class="form-select" id="backup_location" name="backup_location">
                                            <option value="local" selected>محلي</option>
                                            <option value="cloud">سحابي</option>
                                            <option value="both">محلي وسحابي</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="backup_compress" name="backup_compress" checked>
                                            <label class="form-check-label" for="backup_compress">ضغط النسخ الاحتياطية</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="backup_encrypt" name="backup_encrypt" checked>
                                            <label class="form-check-label" for="backup_encrypt">تشفير النسخ الاحتياطية</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <button type="button" class="btn btn-primary" id="saveBackupSettings">
                                            <i class="bi bi-save"></i> حفظ إعدادات النسخ الاحتياطي
                                        </button>
                                    </div>
                                </div>
                            </form>
                            
                            <hr>
                            
                            <h6 class="mb-3">النسخ الاحتياطية المتوفرة</h6>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>اسم الملف</th>
                                            <th>الحجم</th>
                                            <th>تاريخ الإنشاء</th>
                                            <th>النوع</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>backup_2025-04-19_02-00-00.zip</td>
                                            <td>15.2 MB</td>
                                            <td>2025-04-19 02:00:00</td>
                                            <td>تلقائي</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-primary">
                                                        <i class="bi bi-download"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-success">
                                                        <i class="bi bi-arrow-counterclockwise"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>backup_2025-04-18_02-00-00.zip</td>
                                            <td>14.8 MB</td>
                                            <td>2025-04-18 02:00:00</td>
                                            <td>تلقائي</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-primary">
                                                        <i class="bi bi-download"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-success">
                                                        <i class="bi bi-arrow-counterclockwise"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>backup_2025-04-17_02-00-00.zip</td>
                                            <td>14.5 MB</td>
                                            <td>2025-04-17 02:00:00</td>
                                            <td>تلقائي</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-primary">
                                                        <i class="bi bi-download"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-success">
                                                        <i class="bi bi-arrow-counterclockwise"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- سجلات النظام -->
                <div class="tab-pane fade" id="systemLogs">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">سجلات النظام</h5>
                            <div>
                                <button type="button" class="btn btn-primary btn-sm" id="refreshLogsBtn">
                                    <i class="bi bi-arrow-clockwise"></i> تحديث
                                </button>
                                <button type="button" class="btn btn-danger btn-sm" id="clearLogsBtn">
                                    <i class="bi bi-trash"></i> مسح السجلات
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <form id="logsFilterForm" class="row g-3">
                                        <div class="col-md-3">
                                            <label for="log_type" class="form-label">نوع السجل</label>
                                            <select class="form-select" id="log_type" name="log_type">
                                                <option value="all" selected>الكل</option>
                                                <option value="info">معلومات</option>
                                                <option value="warning">تحذيرات</option>
                                                <option value="error">أخطاء</option>
                                                <option value="login">تسجيل دخول</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label for="log_user" class="form-label">المستخدم</label>
                                            <select class="form-select" id="log_user" name="log_user">
                                                <option value="all" selected>الكل</option>
                                                <option value="1">مدير النظام</option>
                                                <option value="2">موظف صرافة</option>
                                                <option value="3">مشرف حوالات</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label for="log_from_date" class="form-label">من تاريخ</label>
                                            <input type="date" class="form-control" id="log_from_date" name="log_from_date">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="log_to_date" class="form-label">إلى تاريخ</label>
                                            <input type="date" class="form-control" id="log_to_date" name="log_to_date">
                                        </div>
                                        <div class="col-md-12 text-center">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bi bi-search"></i> بحث
                                            </button>
                                            <button type="button" class="btn btn-success ms-2" id="exportLogsBtn">
                                                <i class="bi bi-file-excel"></i> تصدير
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>التاريخ والوقت</th>
                                            <th>النوع</th>
                                            <th>المستخدم</th>
                                            <th>الوصف</th>
                                            <th>IP</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>2025-04-19 13:30:45</td>
                                            <td><span class="badge bg-info">معلومات</span></td>
                                            <td>مدير النظام</td>
                                            <td>تم تسجيل الدخول إلى النظام</td>
                                            <td>192.168.1.1</td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>2025-04-19 13:35:22</td>
                                            <td><span class="badge bg-success">معلومات</span></td>
                                            <td>مدير النظام</td>
                                            <td>تم إضافة عملة جديدة: الجنيه المصري (EGP)</td>
                                            <td>192.168.1.1</td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>2025-04-19 13:40:15</td>
                                            <td><span class="badge bg-warning">تحذير</span></td>
                                            <td>موظف صرافة</td>
                                            <td>محاولة تجاوز الحد الأقصى لمبلغ الحوالة</td>
                                            <td>192.168.1.2</td>
                                        </tr>
                                        <tr>
                                            <td>4</td>
                                            <td>2025-04-19 13:45:30</td>
                                            <td><span class="badge bg-info">معلومات</span></td>
                                            <td>مشرف حوالات</td>
                                            <td>تم تسجيل الدخول إلى النظام</td>
                                            <td>192.168.1.3</td>
                                        </tr>
                                        <tr>
                                            <td>5</td>
                                            <td>2025-04-19 13:50:12</td>
                                            <td><span class="badge bg-success">معلومات</span></td>
                                            <td>مشرف حوالات</td>
                                            <td>تم تأكيد استلام الحوالة رقم REM-000123</td>
                                            <td>192.168.1.3</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            
                            <nav aria-label="Page navigation">
                                <ul class="pagination justify-content-center mt-3">
                                    <li class="page-item disabled">
                                        <a class="page-link" href="#" tabindex="-1" aria-disabled="true">السابق</a>
                                    </li>
                                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                                    <li class="page-item">
                                        <a class="page-link" href="#">التالي</a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة مستخدم -->
<div class="modal fade" id="addUserModal" tabindex="-1" aria-labelledby="addUserModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addUserModalLabel">إضافة مستخدم جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <form id="addUserForm">
                    <div class="mb-3">
                        <label for="username" class="form-label">اسم المستخدم <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="username" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">البريد الإلكتروني <span class="text-danger">*</span></label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">كلمة المرور <span class="text-danger">*</span></label>
                        <input type="password" class="form-control" id="password" name="password" required>
                    </div>
                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">تأكيد كلمة المرور <span class="text-danger">*</span></label>
                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                    </div>
                    <div class="mb-3">
                        <label for="role" class="form-label">الدور <span class="text-danger">*</span></label>
                        <select class="form-select" id="role" name="role" required>
                            <option value="">-- اختر الدور --</option>
                            <option value="1">مدير النظام</option>
                            <option value="2">مشرف</option>
                            <option value="3">موظف</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="active" name="active" checked>
                            <label class="form-check-label" for="active">نشط</label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn btn-primary" id="saveNewUser">حفظ</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تعديل مستخدم -->
<div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editUserModalLabel">تعديل بيانات المستخدم</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <form id="editUserForm">
                    <div class="mb-3">
                        <label for="edit_username" class="form-label">اسم المستخدم <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="edit_username" name="username" value="موظف صرافة" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_email" class="form-label">البريد الإلكتروني <span class="text-danger">*</span></label>
                        <input type="email" class="form-control" id="edit_email" name="email" value="cashier@codeplus.com" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_password" class="form-label">كلمة المرور (اتركها فارغة إذا لم ترغب في تغييرها)</label>
                        <input type="password" class="form-control" id="edit_password" name="password">
                    </div>
                    <div class="mb-3">
                        <label for="edit_password_confirmation" class="form-label">تأكيد كلمة المرور</label>
                        <input type="password" class="form-control" id="edit_password_confirmation" name="password_confirmation">
                    </div>
                    <div class="mb-3">
                        <label for="edit_role" class="form-label">الدور <span class="text-danger">*</span></label>
                        <select class="form-select" id="edit_role" name="role" required>
                            <option value="1">مدير النظام</option>
                            <option value="2">مشرف</option>
                            <option value="3" selected>موظف</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="edit_active" name="active" checked>
                            <label class="form-check-label" for="edit_active">نشط</label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn btn-primary" id="updateUser">حفظ التغييرات</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة صلاحيات المستخدم -->
<div class="modal fade" id="userPermissionsModal" tabindex="-1" aria-labelledby="userPermissionsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="userPermissionsModalLabel">صلاحيات المستخدم: موظف صرافة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <form id="userPermissionsForm">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <h6>إدارة العملات</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_currencies" checked>
                                <label class="form-check-label" for="perm_view_currencies">عرض العملات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_add_currencies">
                                <label class="form-check-label" for="perm_add_currencies">إضافة عملات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_edit_currencies">
                                <label class="form-check-label" for="perm_edit_currencies">تعديل العملات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_delete_currencies">
                                <label class="form-check-label" for="perm_delete_currencies">حذف العملات</label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h6>إدارة أسعار الصرف</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_rates" checked>
                                <label class="form-check-label" for="perm_view_rates">عرض الأسعار</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_edit_rates">
                                <label class="form-check-label" for="perm_edit_rates">تعديل الأسعار</label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h6>إدارة العملاء</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_customers" checked>
                                <label class="form-check-label" for="perm_view_customers">عرض العملاء</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_add_customers" checked>
                                <label class="form-check-label" for="perm_add_customers">إضافة عملاء</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_edit_customers" checked>
                                <label class="form-check-label" for="perm_edit_customers">تعديل العملاء</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_delete_customers">
                                <label class="form-check-label" for="perm_delete_customers">حذف العملاء</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <h6>إدارة المعاملات</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_transactions" checked>
                                <label class="form-check-label" for="perm_view_transactions">عرض المعاملات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_add_transactions" checked>
                                <label class="form-check-label" for="perm_add_transactions">إضافة معاملات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_edit_transactions">
                                <label class="form-check-label" for="perm_edit_transactions">تعديل المعاملات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_cancel_transactions">
                                <label class="form-check-label" for="perm_cancel_transactions">إلغاء المعاملات</label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h6>إدارة الحوالات</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_remittances" checked>
                                <label class="form-check-label" for="perm_view_remittances">عرض الحوالات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_add_remittances" checked>
                                <label class="form-check-label" for="perm_add_remittances">إضافة حوالات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_edit_remittances">
                                <label class="form-check-label" for="perm_edit_remittances">تعديل الحوالات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_receive_remittances" checked>
                                <label class="form-check-label" for="perm_receive_remittances">استلام الحوالات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_cancel_remittances">
                                <label class="form-check-label" for="perm_cancel_remittances">إلغاء الحوالات</label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h6>التقارير</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_reports" checked>
                                <label class="form-check-label" for="perm_view_reports">عرض التقارير</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_export_reports">
                                <label class="form-check-label" for="perm_export_reports">تصدير التقارير</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_financial_reports">
                                <label class="form-check-label" for="perm_view_financial_reports">عرض التقارير المالية</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <h6>إدارة النظام</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_settings">
                                <label class="form-check-label" for="perm_view_settings">عرض الإعدادات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_edit_settings">
                                <label class="form-check-label" for="perm_edit_settings">تعديل الإعدادات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_logs">
                                <label class="form-check-label" for="perm_view_logs">عرض السجلات</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_manage_backup">
                                <label class="form-check-label" for="perm_manage_backup">إدارة النسخ الاحتياطي</label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h6>إدارة المستخدمين</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_users">
                                <label class="form-check-label" for="perm_view_users">عرض المستخدمين</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_add_users">
                                <label class="form-check-label" for="perm_add_users">إضافة مستخدمين</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_edit_users">
                                <label class="form-check-label" for="perm_edit_users">تعديل المستخدمين</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_manage_permissions">
                                <label class="form-check-label" for="perm_manage_permissions">إدارة الصلاحيات</label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <h6>أخرى</h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_access_api">
                                <label class="form-check-label" for="perm_access_api">الوصول إلى API</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_view_dashboard" checked>
                                <label class="form-check-label" for="perm_view_dashboard">عرض لوحة التحكم</label>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn btn-primary" id="savePermissions">حفظ الصلاحيات</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تعديل دور -->
<div class="modal fade" id="editRoleModal" tabindex="-1" aria-labelledby="editRoleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editRoleModalLabel">تعديل الدور</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <form id="editRoleForm">
                    <div class="mb-3">
                        <label for="role_name" class="form-label">اسم الدور <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="role_name" name="role_name" value="موظف" required>
                    </div>
                    <div class="mb-3">
                        <label for="role_description" class="form-label">وصف الدور</label>
                        <textarea class="form-control" id="role_description" name="role_description" rows="3">صلاحيات إجراء المعاملات والحوالات</textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn btn-primary" id="updateRole">حفظ التغييرات</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // حفظ الإعدادات العامة
        document.getElementById('saveGeneralSettings').addEventListener('click', function() {
            alert('تم حفظ الإعدادات العامة بنجاح');
        });
        
        // حفظ معلومات الشركة
        document.getElementById('saveCompanySettings').addEventListener('click', function() {
            alert('تم حفظ معلومات الشركة بنجاح');
        });
        
        // حفظ إعدادات العملات
        document.getElementById('saveCurrencySettings').addEventListener('click', function() {
            alert('تم حفظ إعدادات العملات بنجاح');
        });
        
        // حفظ إعدادات الحوالات
        document.getElementById('saveRemittanceSettings').addEventListener('click', function() {
            alert('تم حفظ إعدادات الحوالات بنجاح');
        });
        
        // إنشاء نسخة احتياطية
        document.getElementById('createBackupBtn').addEventListener('click', function() {
            alert('جاري إنشاء نسخة احتياطية جديدة...');
            setTimeout(function() {
                alert('تم إنشاء النسخة الاحتياطية بنجاح');
            }, 2000);
        });
        
        // حفظ إعدادات النسخ الاحتياطي
        document.getElementById('saveBackupSettings').addEventListener('click', function() {
            alert('تم حفظ إعدادات النسخ الاحتياطي بنجاح');
        });
        
        // تحديث سجلات النظام
        document.getElementById('refreshLogsBtn').addEventListener('click', function() {
            alert('تم تحديث سجلات النظام');
        });
        
        // مسح سجلات النظام
        document.getElementById('clearLogsBtn').addEventListener('click', function() {
            if (confirm('هل أنت متأكد من مسح جميع سجلات النظام؟')) {
                alert('تم مسح سجلات النظام بنجاح');
            }
        });
        
        // تصدير سجلات النظام
        document.getElementById('exportLogsBtn').addEventListener('click', function() {
            alert('جاري تصدير سجلات النظام...');
        });
        
        // حفظ مستخدم جديد
        document.getElementById('saveNewUser').addEventListener('click', function() {
            alert('تم إضافة المستخدم الجديد بنجاح');
            $('#addUserModal').modal('hide');
        });
        
        // تحديث بيانات المستخدم
        document.getElementById('updateUser').addEventListener('click', function() {
            alert('تم تحديث بيانات المستخدم بنجاح');
            $('#editUserModal').modal('hide');
        });
        
        // حفظ صلاحيات المستخدم
        document.getElementById('savePermissions').addEventListener('click', function() {
            alert('تم حفظ صلاحيات المستخدم بنجاح');
            $('#userPermissionsModal').modal('hide');
        });
        
        // تحديث الدور
        document.getElementById('updateRole').addEventListener('click', function() {
            alert('تم تحديث الدور بنجاح');
            $('#editRoleModal').modal('hide');
        });
        
        // تفعيل/تعطيل حقول التاريخ المخصصة في نموذج تصفية السجلات
        document.getElementById('logsFilterForm').addEventListener('submit', function(e) {
            e.preventDefault();
            alert('جاري تصفية السجلات...');
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\currencyexchange\resources\views/settings/index.blade.php ENDPATH**/ ?>