<?php $__env->startSection('title', 'إدارة أسعار الصرف'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">أسعار الصرف الحالية</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addExchangeRateModal">
                <i class="bi bi-plus-lg"></i> إضافة سعر صرف جديد
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>من العملة</th>
                            <th>إلى العملة</th>
                            <th>سعر الشراء</th>
                            <th>سعر البيع</th>
                            <th>تاريخ السريان</th>
                            <th>الحالة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($exchangeRates) && count($exchangeRates) > 0): ?>
                            <?php $__currentLoopData = $exchangeRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2"><?php echo e($rate->fromCurrency->symbol); ?></span>
                                            <?php echo e($rate->fromCurrency->code); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="me-2"><?php echo e($rate->toCurrency->symbol); ?></span>
                                            <?php echo e($rate->toCurrency->code); ?>

                                        </div>
                                    </td>
                                    <td><?php echo e(number_format($rate->buy_rate, 6)); ?></td>
                                    <td><?php echo e(number_format($rate->sell_rate, 6)); ?></td>
                                    <td><?php echo e($rate->effective_date); ?></td>
                                    <td>
                                        <?php if($rate->is_active): ?>
                                            <span class="badge bg-success">نشط</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">غير نشط</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editExchangeRateModal<?php echo e($rate->id); ?>">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteExchangeRateModal<?php echo e($rate->id); ?>">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">لا توجد أسعار صرف مسجلة</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة سعر صرف جديد -->
<div class="modal fade" id="addExchangeRateModal" tabindex="-1" aria-labelledby="addExchangeRateModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('exchange-rates.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="addExchangeRateModalLabel">إضافة سعر صرف جديد</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="from_currency_id" class="form-label">من العملة <span class="text-danger">*</span></label>
                        <select class="form-select" id="from_currency_id" name="from_currency_id" required>
                            <option value="">-- اختر العملة --</option>
                            <?php if(isset($currencies)): ?>
                                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="to_currency_id" class="form-label">إلى العملة <span class="text-danger">*</span></label>
                        <select class="form-select" id="to_currency_id" name="to_currency_id" required>
                            <option value="">-- اختر العملة --</option>
                            <?php if(isset($currencies)): ?>
                                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="rate" class="form-label">سعر الصرف الأساسي <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="rate" name="rate" required step="0.000001" min="0.000001">
                    </div>
                    <div class="mb-3">
                        <label for="buy_rate" class="form-label">سعر الشراء</label>
                        <input type="number" class="form-control" id="buy_rate" name="buy_rate" step="0.000001" min="0.000001">
                        <div class="form-text">إذا تركت هذا الحقل فارغًا، سيتم استخدام سعر الصرف الأساسي</div>
                    </div>
                    <div class="mb-3">
                        <label for="sell_rate" class="form-label">سعر البيع</label>
                        <input type="number" class="form-control" id="sell_rate" name="sell_rate" step="0.000001" min="0.000001">
                        <div class="form-text">إذا تركت هذا الحقل فارغًا، سيتم استخدام سعر الصرف الأساسي</div>
                    </div>
                    <div class="mb-3">
                        <label for="effective_date" class="form-label">تاريخ السريان <span class="text-danger">*</span></label>
                        <input type="datetime-local" class="form-control" id="effective_date" name="effective_date" required>
                    </div>
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" checked>
                        <label class="form-check-label" for="is_active">نشط</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نوافذ تعديل وحذف أسعار الصرف (ستتم إضافتها ديناميكيًا لكل سعر صرف) -->
<?php if(isset($exchangeRates)): ?>
    <?php $__currentLoopData = $exchangeRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- نافذة تعديل سعر الصرف -->
        <div class="modal fade" id="editExchangeRateModal<?php echo e($rate->id); ?>" tabindex="-1" aria-labelledby="editExchangeRateModalLabel<?php echo e($rate->id); ?>" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="<?php echo e(route('exchange-rates.update', $rate->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="modal-header">
                            <h5 class="modal-title" id="editExchangeRateModalLabel<?php echo e($rate->id); ?>">تعديل سعر الصرف</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">من العملة</label>
                                <input type="text" class="form-control" value="<?php echo e($rate->fromCurrency->code); ?> - <?php echo e($rate->fromCurrency->name); ?>" readonly>
                                <input type="hidden" name="from_currency_id" value="<?php echo e($rate->from_currency_id); ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">إلى العملة</label>
                                <input type="text" class="form-control" value="<?php echo e($rate->toCurrency->code); ?> - <?php echo e($rate->toCurrency->name); ?>" readonly>
                                <input type="hidden" name="to_currency_id" value="<?php echo e($rate->to_currency_id); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="edit_rate<?php echo e($rate->id); ?>" class="form-label">سعر الصرف الأساسي <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="edit_rate<?php echo e($rate->id); ?>" name="rate" required step="0.000001" min="0.000001" value="<?php echo e($rate->rate); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="edit_buy_rate<?php echo e($rate->id); ?>" class="form-label">سعر الشراء</label>
                                <input type="number" class="form-control" id="edit_buy_rate<?php echo e($rate->id); ?>" name="buy_rate" step="0.000001" min="0.000001" value="<?php echo e($rate->buy_rate); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="edit_sell_rate<?php echo e($rate->id); ?>" class="form-label">سعر البيع</label>
                                <input type="number" class="form-control" id="edit_sell_rate<?php echo e($rate->id); ?>" name="sell_rate" step="0.000001" min="0.000001" value="<?php echo e($rate->sell_rate); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="edit_effective_date<?php echo e($rate->id); ?>" class="form-label">تاريخ السريان <span class="text-danger">*</span></label>
                                <input type="datetime-local" class="form-control" id="edit_effective_date<?php echo e($rate->id); ?>" name="effective_date" required value="<?php echo e(date('Y-m-d\TH:i', strtotime($rate->effective_date))); ?>">
                            </div>
                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="edit_is_active<?php echo e($rate->id); ?>" name="is_active" <?php echo e($rate->is_active ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="edit_is_active<?php echo e($rate->id); ?>">نشط</label>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- نافذة حذف سعر الصرف -->
        <div class="modal fade" id="deleteExchangeRateModal<?php echo e($rate->id); ?>" tabindex="-1" aria-labelledby="deleteExchangeRateModalLabel<?php echo e($rate->id); ?>" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="<?php echo e(route('exchange-rates.destroy', $rate->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteExchangeRateModalLabel<?php echo e($rate->id); ?>">تأكيد الحذف</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <p>هل أنت متأكد من حذف سعر الصرف بين <?php echo e($rate->fromCurrency->code); ?> و <?php echo e($rate->toCurrency->code); ?>؟</p>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle"></i>
                                تحذير: قد يؤثر حذف سعر الصرف هذا على المعاملات والحوالات المرتبطة به.
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    // تحديث سعر الشراء والبيع تلقائيًا عند تغيير سعر الصرف الأساسي
    document.getElementById('rate').addEventListener('input', function() {
        const rate = parseFloat(this.value) || 0;
        document.getElementById('buy_rate').value = rate;
        document.getElementById('sell_rate').value = rate;
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\currencyexchange\resources\views/exchange_rates/index.blade.php ENDPATH**/ ?>