<?php

use App\Http\Controllers\Auth\AuthController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\ExchangeRateController;
use App\Http\Controllers\RemittanceController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ReportController;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/




// الصفحة الرئيسية
Route::get('/', function () {
    return redirect()->route('dashboard');
});


// مسارات المصادقة
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/register', [AuthController::class, 'showRegistrationForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);



// Auth::routes();

Route::middleware(['auth'])->group(function () {

    // لوحة التحكم
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // إدارة العملات
    Route::resource('currencies', CurrencyController::class);
    Route::post('currencies/search', [CurrencyController::class, 'search'])->name('currencies.search');
    Route::post('currencies/{currency}/toggle-status', [CurrencyController::class, 'toggleStatus'])->name('currencies.toggle-status');

    // إدارة أسعار الصرف
    Route::resource('exchange-rates', ExchangeRateController::class);
    Route::post('exchange-rates/{exchange_rate}/toggle-status', [ExchangeRateController::class, 'toggleStatus'])->name('exchange-rates.toggle-status');
    Route::post('exchange-rates/get-rate', [ExchangeRateController::class, 'getRate'])->name('exchange-rates.get-rate');
    Route::post('exchange-rates/bulk-update', [ExchangeRateController::class, 'bulkUpdate'])->name('exchange-rates.bulk-update');

    // إدارة الحوالات المالية
    Route::resource('remittances', RemittanceController::class);
    Route::post('remittances/search', [RemittanceController::class, 'search'])->name('remittances.search');
    Route::post('remittances/{remittance}/update-status', [RemittanceController::class, 'updateStatus'])->name('remittances.update-status');
    Route::get('remittances/{remittance}/print', [RemittanceController::class, 'printReceipt'])->name('remittances.print');
    Route::get('check-remittance-status', [RemittanceController::class, 'checkStatus'])->name('remittances.check-status');
    Route::post('check-remittance-status', [RemittanceController::class, 'checkStatus'])->name('remittances.check-status.post');

    // نظام التقارير والإحصائيات
    Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
    Route::get('/reports/remittances', [ReportController::class, 'remittancesReport'])->name('reports.remittances');
    Route::get('/reports/exchange-rates', [ReportController::class, 'exchangeRatesReport'])->name('reports.exchange-rates');
    Route::get('/reports/revenue', [ReportController::class, 'revenueReport'])->name('reports.revenue');
    Route::get('/reports/customers', [ReportController::class, 'customersReport'])->name('reports.customers');
    Route::get('/reports/performance', [ReportController::class, 'performanceSummary'])->name('reports.performance');
    Route::get('/reports/remittances/export', [ReportController::class, 'exportRemittancesReport'])->name('reports.remittances.export');

    // إعدادات النظام
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingsController::class, 'update'])->name('settings.update');


    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

});