@extends('layouts.app')

@section('title', 'إدارة العملاء')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">قائمة العملاء</h5>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCustomerModal">
                <i class="bi bi-plus-lg"></i> إضافة عميل جديد
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>الاسم</th>
                            <th>رقم الهاتف</th>
                            <th>البريد الإلكتروني</th>
                            <th>نوع الهوية</th>
                            <th>رقم الهوية</th>
                            <th>الجنسية</th>
                            <th>الحالة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($customers) && count($customers) > 0)
                            @foreach($customers as $customer)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $customer->name }}</td>
                                    <td>{{ $customer->phone }}</td>
                                    <td>{{ $customer->email }}</td>
                                    <td>{{ $customer->id_type }}</td>
                                    <td>{{ $customer->id_number }}</td>
                                    <td>{{ $customer->nationality }}</td>
                                    <td>
                                        @if($customer->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#viewCustomerModal{{ $customer->id }}">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editCustomerModal{{ $customer->id }}">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteCustomerModal{{ $customer->id }}">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="9" class="text-center">لا يوجد عملاء مسجلين</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة عميل جديد -->
<div class="modal fade" id="addCustomerModal" tabindex="-1" aria-labelledby="addCustomerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="{{ route('customers.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addCustomerModalLabel">إضافة عميل جديد</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label">الاسم <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">رقم الهاتف</label>
                            <input type="text" class="form-control" id="phone" name="phone">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">البريد الإلكتروني</label>
                            <input type="email" class="form-control" id="email" name="email">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="nationality" class="form-label">الجنسية</label>
                            <input type="text" class="form-control" id="nationality" name="nationality">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="id_type" class="form-label">نوع الهوية</label>
                            <select class="form-select" id="id_type" name="id_type">
                                <option value="">-- اختر نوع الهوية --</option>
                                <option value="جواز سفر">جواز سفر</option>
                                <option value="بطاقة هوية">بطاقة هوية</option>
                                <option value="إقامة">إقامة</option>
                                <option value="رخصة قيادة">رخصة قيادة</option>
                                <option value="أخرى">أخرى</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="id_number" class="form-label">رقم الهوية</label>
                            <input type="text" class="form-control" id="id_number" name="id_number">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="id_expiry_date" class="form-label">تاريخ انتهاء الهوية</label>
                            <input type="date" class="form-control" id="id_expiry_date" name="id_expiry_date">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="address" class="form-label">العنوان</label>
                            <input type="text" class="form-control" id="address" name="address">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                    </div>
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" checked>
                        <label class="form-check-label" for="is_active">نشط</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نوافذ عرض وتعديل وحذف العملاء (ستتم إضافتها ديناميكيًا لكل عميل) -->
@if(isset($customers))
    @foreach($customers as $customer)
        <!-- نافذة عرض بيانات العميل -->
        <div class="modal fade" id="viewCustomerModal{{ $customer->id }}" tabindex="-1" aria-labelledby="viewCustomerModalLabel{{ $customer->id }}" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="viewCustomerModalLabel{{ $customer->id }}">بيانات العميل: {{ $customer->name }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <h6>الاسم:</h6>
                                <p>{{ $customer->name }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <h6>رقم الهاتف:</h6>
                                <p>{{ $customer->phone ?? 'غير متوفر' }}</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <h6>البريد الإلكتروني:</h6>
                                <p>{{ $customer->email ?? 'غير متوفر' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <h6>الجنسية:</h6>
                                <p>{{ $customer->nationality ?? 'غير متوفر' }}</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <h6>نوع الهوية:</h6>
                                <p>{{ $customer->id_type ?? 'غير متوفر' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <h6>رقم الهوية:</h6>
                                <p>{{ $customer->id_number ?? 'غير متوفر' }}</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <h6>تاريخ انتهاء الهوية:</h6>
                                <p>{{ $customer->id_expiry_date ?? 'غير متوفر' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <h6>العنوان:</h6>
                                <p>{{ $customer->address ?? 'غير متوفر' }}</p>
                            </div>
                        </div>
                        <div class="mb-3">
                            <h6>ملاحظات:</h6>
                            <p>{{ $customer->notes ?? 'لا توجد ملاحظات' }}</p>
                        </div>
                        <div class="mb-3">
                            <h6>الحالة:</h6>
                            <p>
                                @if($customer->is_active)
                                    <span class="badge bg-success">نشط</span>
                                @else
                                    <span class="badge bg-danger">غير نشط</span>
                                @endif
                            </p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- نافذة تعديل بيانات العميل -->
        <div class="modal fade" id="editCustomerModal{{ $customer->id }}" tabindex="-1" aria-labelledby="editCustomerModalLabel{{ $customer->id }}" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <form action="{{ route('customers.update', $customer->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-header">
                            <h5 class="modal-title" id="editCustomerModalLabel{{ $customer->id }}">تعديل بيانات العميل</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <!-- نفس حقول نموذج الإضافة مع تعبئة البيانات الحالية -->
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="edit_name{{ $customer->id }}" class="form-label">الاسم <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="edit_name{{ $customer->id }}" name="name" required value="{{ $customer->name }}">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="edit_phone{{ $customer->id }}" class="form-label">رقم الهاتف</label>
                                    <input type="text" class="form-control" id="edit_phone{{ $customer->id }}" name="phone" value="{{ $customer->phone }}">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="edit_email{{ $customer->id }}" class="form-label">البريد الإلكتروني</label>
                                    <input type="email" class="form-control" id="edit_email{{ $customer->id }}" name="email" value="{{ $customer->email }}">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="edit_nationality{{ $customer->id }}" class="form-label">الجنسية</label>
                                    <input type="text" class="form-control" id="edit_nationality{{ $customer->id }}" name="nationality" value="{{ $customer->nationality }}">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="edit_id_type{{ $customer->id }}" class="form-label">نوع الهوية</label>
                                    <select class="form-select" id="edit_id_type{{ $customer->id }}" name="id_type">
                                        <option value="">-- اختر نوع الهوية --</option>
                                        <option value="جواز سفر" {{ $customer->id_type == 'جواز سفر' ? 'selected' : '' }}>جواز سفر</option>
                                        <option value="بطاقة هوية" {{ $customer->id_type == 'بطاقة هوية' ? 'selected' : '' }}>بطاقة هوية</option>
                                        <option value="إقامة" {{ $customer->id_type == 'إقامة' ? 'selected' : '' }}>إقامة</option>
                                        <option value="رخصة قيادة" {{ $customer->id_type == 'رخصة قيادة' ? 'selected' : '' }}>رخصة قيادة</option>
                                        <option value="أخرى" {{ $customer->id_type == 'أخرى' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="edit_id_number{{ $customer->id }}" class="form-label">رقم الهوية</label>
                                    <input type="text" class="form-control" id="edit_id_number{{ $customer->id }}" name="id_number" value="{{ $customer->id_number }}">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="edit_id_expiry_date{{ $customer->id }}" class="form-label">تاريخ انتهاء الهوية</label>
                                    <input type="date" class="form-control" id="edit_id_expiry_date{{ $customer->id }}" name="id_expiry_date" value="{{ $customer->id_expiry_date }}">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="edit_address{{ $customer->id }}" class="form-label">العنوان</label>
                                    <input type="text" class="form-control" id="edit_address{{ $customer->id }}" name="address" value="{{ $customer->address }}">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="edit_notes{{ $customer->id }}" class="form-label">ملاحظات</label>
                                <textarea class="form-control" id="edit_notes{{ $customer->id }}" name="notes" rows="3">{{ $customer->notes }}</textarea>
                            </div>
                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="edit_is_active{{ $customer->id }}" name="is_active" {{ $customer->is_active ? 'checked' : '' }}>
                                <label class="form-check-label" for="edit_is_active{{ $customer->id }}">نشط</label>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- نافذة حذف العميل -->
        <div class="modal fade" id="deleteCustomerModal{{ $customer->id }}" tabindex="-1" aria-labelledby="deleteCustomerModalLabel{{ $customer->id }}" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form action="{{ route('customers.destroy', $customer->id) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteCustomerModalLabel{{ $customer->id }}">تأكيد الحذف</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                        </div>
                        <div class="modal-body">
                            <p>هل أنت متأكد من حذف العميل "{{ $customer->name }}"؟</p>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle"></i>
                                تحذير: سيؤدي حذف هذا العميل إلى حذف جميع المعاملات والحوالات المرتبطة به.
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
@endif
@endsection
