<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم العميل
            $table->string('phone')->nullable(); // رقم الهاتف
            $table->string('email')->nullable(); // البريد الإلكتروني
            $table->string('address')->nullable(); // العنوان
            $table->string('id_type')->nullable(); // نوع الهوية (جواز سفر، بطاقة هوية، إقامة)
            $table->string('id_number')->nullable(); // رقم الهوية
            $table->date('id_expiry_date')->nullable(); // تاريخ انتهاء الهوية
            $table->string('nationality')->nullable(); // الجنسية
            $table->text('notes')->nullable(); // ملاحظات
            $table->boolean('is_active')->default(true); // حالة العميل (نشط أو غير نشط)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
