<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('key', 100)->unique();
            $table->text('value')->nullable();
            $table->string('display_name', 100);
            $table->text('description')->nullable();
            $table->enum('type', ['text', 'number', 'boolean', 'select', 'textarea', 'file', 'color', 'date', 'time', 'datetime', 'json'])->default('text');
            $table->json('options')->nullable();
            $table->string('group', 50)->default('general');
            $table->boolean('is_system')->default(false);
            $table->boolean('is_public')->default(false);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            
            $table->index('group');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
