<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_templates', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 100);
            $table->text('description')->nullable();
            $table->text('html_template')->nullable();
            $table->json('available_parameters')->nullable();
            $table->string('thumbnail', 255)->nullable();
            $table->boolean('is_system')->default(false);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
        
        // إضافة العلاقة في جدول التقارير
        Schema::table('reports', function (Blueprint $table) {
            $table->foreign('template_id')->references('id')->on('report_templates')
                  ->onDelete('set null')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->dropForeign(['template_id']);
        });
        
        Schema::dropIfExists('report_templates');
    }
};
