<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->enum('transaction_type', ['remittance', 'exchange', 'deposit', 'withdrawal', 'transfer', 'payment', 'fee', 'commission', 'adjustment']);
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->string('reference_type', 50)->nullable();
            $table->decimal('amount', 15, 2);
            $table->unsignedInteger('currency_id');
            $table->unsignedInteger('account_id')->nullable();
            $table->text('description')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->unsignedInteger('branch_id');
            $table->timestamp('created_at')->useCurrent();
            
            $table->index(['reference_id', 'reference_type']);
            $table->index('transaction_type');
            $table->index('created_at');
            
            $table->foreign('currency_id')->references('id')->on('currencies')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('user_id')->references('id')->on('users')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('branch_id')->references('id')->on('branches')
                  ->onDelete('restrict')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
