<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currency_exchanges', function (Blueprint $table) {
            $table->id();
            $table->string('reference_number', 20)->unique();
            $table->string('customer_name', 100)->nullable();
            $table->string('customer_phone', 20)->nullable();
            $table->unsignedInteger('from_currency_id');
            $table->unsignedInteger('to_currency_id');
            $table->decimal('from_amount', 15, 2);
            $table->decimal('exchange_rate', 15, 6);
            $table->decimal('to_amount', 15, 2);
            $table->decimal('fee', 10, 2)->default(0.00);
            $table->decimal('profit', 10, 2)->default(0.00);
            $table->unsignedInteger('branch_id');
            $table->unsignedBigInteger('user_id');
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index('created_at');
            
            $table->foreign('from_currency_id')->references('id')->on('currencies')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('to_currency_id')->references('id')->on('currencies')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('branch_id')->references('id')->on('branches')
                  ->onDelete('restrict')->onUpdate('cascade');
            $table->foreign('user_id')->references('id')->on('users')
                  ->onDelete('restrict')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currency_exchanges');
    }
};
