<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exchange_rate_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('from_currency_id');
            $table->unsignedInteger('to_currency_id');
            $table->decimal('rate', 15, 6);
            $table->decimal('buy_rate', 15, 6);
            $table->decimal('sell_rate', 15, 6);
            $table->unsignedBigInteger('updated_by');
            $table->timestamp('created_at')->useCurrent();
            
            $table->index('from_currency_id');
            $table->index('to_currency_id');
            $table->index('created_at');
            
            $table->foreign('from_currency_id')->references('id')->on('currencies')
                  ->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('to_currency_id')->references('id')->on('currencies')
                  ->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('updated_by')->references('id')->on('users')
                  ->onDelete('restrict')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exchange_rate_history');
    }
};
