<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currency_api_sources', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 100);
            $table->string('api_url', 255);
            $table->string('api_key', 255)->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('update_frequency')->default(3600);
            $table->dateTime('last_update')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currency_api_sources');
    }
};
